#ifndef HASH_H
#define HASH_H

#include "defs.h"

using namespace std;

struct sHashelem {
       u64 key;
       uint move;
       int score;
       int depth;
       uint flag;
};


class cHashtable {

private:
         sHashelem *table;

         uint elements;
         uint write;
         uint probe;
         uint hit;

         void init_table_memory();

         cHashtable( const cHashtable & );
         cHashtable &operator = ( const cHashtable & );

         void resetcounters() { hit=probe=write=0;}

public:
         cHashtable();
         void reset_tables();
         void delete_tables();
         void makenewtable(const uint elem);

         uint getwritten() { return write; }
         uint getprobe() { return probe; }
         uint gethit() { return hit; }
         uint getelements() { return elements; }

         void says_stats();

         uint probe_hashentry(int &score, const int depth, uint &move, const int &beta, bool &donull, const u64 &key, const uint ply);
         void store_hashentry(const int score, const uint flag, const uint move, const int depth, const u64 &key);


};

#endif
